/** @file   youkocontroller.h
 * @brief   Declaration of YoukoController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_YOUKOCONTROLLER_H
#define H_WWW_YOUKOCONTROLLER_H

#include "npccontroller.h"

namespace WeWantWar {

/** @class  YoukoController
 * @brief   Controls the special NpcCharacter named Youko.
 * @author  Tomi Lamminsaari
 *
 */
class YoukoController : public NpcController
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  enum {
    YOUKO_ARRESTED,       // 0
    YOUKO_AVOID_ENEMIES,  // 1
    YOUKO_FOLLOW_PLAYER,  // 2
    YOUKO_FIGHT           // 3
  };


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     pObject           Pointer to object we're supposed to control.
   */
	YoukoController( GameObject* pObject );


	/** Destructor
   */
	virtual ~YoukoController();

private:

	/** Copy constructor.
   * @param     rO                Reference to another YoukoController
   */
  YoukoController( const YoukoController& rO );

	/** Assignment operator
   * @param     rO                Reference to another YoukoController
   * @return    Reference to us.
   */
  YoukoController& operator = ( const YoukoController& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this controller
   */
  virtual void updateNpc();
  
  /** Sets the Youko's state
   * @param     nstate            New state
   */
  void youkoState( int nstate );

  /** Sets the centerpos.
   * @param     cpos              New centerposition
   */
  void centerPosition( const eng2d::Vec2D& cpos );
  
  

  ///
  /// Getter methods
  /// ==============
  
  /** Returns the current state
   * @return    Current state
   */
  int youkoState() const;


protected:

  ///
  /// Members
  /// =======

  int   m_youkoState;
  eng2d::Vec2D  m_centerPos;
  float m_maxDistance1;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: youkocontroller.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:23+02  lamminsa
 * Initial revision
 *
 */
 
